// Automatically generated by lang_tables.pl

#include <stdint.h>

// Keyboard language tables

// All symbols are 16 bits, consisting of FLAGS|CODE symbol followed by data.

// FLAGS|CODE   top 8 bits flags, bottom 8 bits scancode, all zeros to end
//      [LANG]    language dependency if LANG inherit flag set
//      [SYM1]    level 1 sym if SYM1 flag set
//      [SYM2]    level 2 sym if SYM2 flag set
//      [SYM3]    level 3 sym if SYM3 flag set
//      [SYM4]    level 4 sym if SYM4 flag set

// Flags are processed in this order:
#define HKL_LANG  (1 << 15)      // inherit language
#define HKL_CLR   (1 << 14)      // clear all levels
#define HKL_SYM1  (1 << 8)       // level 1 sym
#define HKL_SYM2  (1 << 9)       // level 2 sym
#define HKL_SYM3  (1 << 10)      // level 3 sym
#define HKL_SYM4  (1 << 11)      // level 4 sym
#define HKL_DUP1  (1 << 12)      // copy level 1 to level 2
#define HKL_DUP12 (1 << 13)      // copy levels 1 & 2 to levels 3 & 4

// Convenience macros:
#define HKL_SYM12 (HKL_SYM1 | HKL_SYM2)
#define HKL_SYM34 (HKL_SYM3 | HKL_SYM4)
#define HKL_SYM1234 (HKL_SYM12 | HKL_SYM34)
#define HKL_END (0)

// Default symbol table

static const uint16_t lang_default[] = {
	HKL_SYM1234 | hk_scan_0, hk_sym_0, hk_sym_parenright, hk_sym_braceright, hk_sym_degree,
	HKL_SYM1234 | hk_scan_1, hk_sym_1, hk_sym_exclam, hk_sym_onesuperior, hk_sym_exclamdown,
	HKL_SYM1234 | hk_scan_2, hk_sym_2, hk_sym_at, hk_sym_twosuperior, hk_sym_oneeighth,
	HKL_SYM1234 | hk_scan_3, hk_sym_3, hk_sym_numbersign, hk_sym_threesuperior, hk_sym_sterling,
	HKL_SYM1234 | hk_scan_4, hk_sym_4, hk_sym_dollar, hk_sym_onequarter, hk_sym_dollar,
	HKL_SYM1234 | hk_scan_5, hk_sym_5, hk_sym_percent, hk_sym_onehalf, hk_sym_threeeighths,
	HKL_SYM1234 | hk_scan_6, hk_sym_6, hk_sym_asciicircum, hk_sym_threequarters, hk_sym_fiveeighths,
	HKL_SYM1234 | hk_scan_7, hk_sym_7, hk_sym_ampersand, hk_sym_braceleft, hk_sym_seveneighths,
	HKL_SYM1234 | hk_scan_8, hk_sym_8, hk_sym_asterisk, hk_sym_bracketleft, hk_sym_trademark,
	HKL_SYM1234 | hk_scan_9, hk_sym_9, hk_sym_parenleft, hk_sym_bracketright, hk_sym_plusminus,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Alt_L, hk_sym_Alt_L,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Alt_R, hk_sym_Alt_R,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Application, hk_sym_Menu,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_BackSpace, hk_sym_BackSpace,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Caps_Lock, hk_sym_Caps_Lock,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Control_L, hk_sym_Control_L,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Control_R, hk_sym_Control_R,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Delete, hk_sym_Delete,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Down, hk_sym_Down,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_End, hk_sym_End,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Escape, hk_sym_Escape,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F1, hk_sym_F1,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F10, hk_sym_F10,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F11, hk_sym_F11,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F12, hk_sym_F12,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F2, hk_sym_F2,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F3, hk_sym_F3,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F4, hk_sym_F4,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F5, hk_sym_F5,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F6, hk_sym_F6,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F7, hk_sym_F7,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F8, hk_sym_F8,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_F9, hk_sym_F9,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Home, hk_sym_Home,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Insert, hk_sym_Insert,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_0, hk_sym_KP_0,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_1, hk_sym_KP_1,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_2, hk_sym_KP_2,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_3, hk_sym_KP_3,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_4, hk_sym_KP_4,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_5, hk_sym_KP_5,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_6, hk_sym_KP_6,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_7, hk_sym_KP_7,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_8, hk_sym_KP_8,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_9, hk_sym_KP_9,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Add, hk_sym_KP_Add,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Decimal, hk_sym_KP_Decimal,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Divide, hk_sym_KP_Divide,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Enter, hk_sym_KP_Enter,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Equal, hk_sym_KP_Equal,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Multiply, hk_sym_KP_Multiply,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Separator, hk_sym_KP_Separator,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_KP_Subtract, hk_sym_KP_Subtract,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Left, hk_sym_Left,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Num_Lock, hk_sym_Num_Lock,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Page_Down, hk_sym_Page_Down,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Page_Up, hk_sym_Page_Up,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Pause, hk_sym_Pause,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Print, hk_sym_Print,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Return, hk_sym_Return,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Right, hk_sym_Right,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Scroll_Lock, hk_sym_Scroll_Lock,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Shift_L, hk_sym_Shift_L,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Shift_R, hk_sym_Shift_R,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Super_L, hk_sym_Super_L,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Super_R, hk_sym_Super_R,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Tab, hk_sym_Tab,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Up, hk_sym_Up,
	HKL_SYM1234 | hk_scan_a, hk_sym_a, hk_sym_A, hk_sym_ae, hk_sym_AE,
	HKL_SYM1234 | hk_scan_apostrophe, hk_sym_apostrophe, hk_sym_quotedbl, hk_sym_dead_circumflex, hk_sym_dead_caron,
	HKL_SYM1234 | hk_scan_b, hk_sym_b, hk_sym_B, hk_sym_leftdoublequotemark, hk_sym_leftsinglequotemark,
	HKL_DUP12 | HKL_SYM12 | hk_scan_backslash, hk_sym_backslash, hk_sym_bar,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_backslash, hk_sym_bar, hk_sym_dead_grave, hk_sym_dead_breve,
	HKL_SYM1234 | hk_scan_bracketleft, hk_sym_bracketleft, hk_sym_braceleft, hk_sym_dead_diaeresis, hk_sym_dead_abovering,
	HKL_SYM1234 | hk_scan_bracketright, hk_sym_bracketright, hk_sym_braceright, hk_sym_dead_tilde, hk_sym_dead_macron,
	HKL_SYM1234 | hk_scan_c, hk_sym_c, hk_sym_C, hk_sym_cent, hk_sym_copyright,
	HKL_SYM1234 | hk_scan_comma, hk_sym_comma, hk_sym_less, 0x2022, hk_sym_multiply,
	HKL_SYM1234 | hk_scan_d, hk_sym_d, hk_sym_D, hk_sym_eth, hk_sym_ETH,
	HKL_DUP12 | HKL_SYM12 | hk_scan_e, hk_sym_e, hk_sym_E,
	HKL_SYM1234 | hk_scan_equal, hk_sym_equal, hk_sym_plus, hk_sym_dead_cedilla, hk_sym_dead_ogonek,
	HKL_SYM1234 | hk_scan_f, hk_sym_f, hk_sym_F, hk_sym_dstroke, hk_sym_ordfeminine,
	HKL_SYM1234 | hk_scan_g, hk_sym_g, hk_sym_G, hk_sym_eng, hk_sym_ENG,
	HKL_SYM1234 | hk_scan_grave, hk_sym_grave, hk_sym_asciitilde, hk_sym_notsign, hk_sym_notsign,
	HKL_SYM1234 | hk_scan_h, hk_sym_h, hk_sym_H, hk_sym_hstroke, hk_sym_Hstroke,
	HKL_SYM1234 | hk_scan_i, hk_sym_i, hk_sym_I, hk_sym_rightarrow, hk_sym_idotless,
	HKL_SYM1234 | hk_scan_j, hk_sym_j, hk_sym_J, hk_sym_dead_hook, hk_sym_dead_horn,
	HKL_SYM1234 | hk_scan_k, hk_sym_k, hk_sym_K, hk_sym_kra, hk_sym_ampersand,
	HKL_SYM1234 | hk_scan_l, hk_sym_l, hk_sym_L, hk_sym_lstroke, hk_sym_Lstroke,
	HKL_SYM1234 | hk_scan_m, hk_sym_m, hk_sym_M, hk_sym_mu, hk_sym_masculine,
	HKL_SYM1234 | hk_scan_minus, hk_sym_minus, hk_sym_underscore, hk_sym_backslash, hk_sym_questiondown,
	HKL_SYM1234 | hk_scan_n, hk_sym_n, hk_sym_N, hk_sym_rightdoublequotemark, hk_sym_rightsinglequotemark,
	HKL_SYM1234 | hk_scan_numbersign_nonUS, hk_sym_grave, hk_sym_asciitilde, hk_sym_notsign, hk_sym_notsign,
	HKL_SYM1234 | hk_scan_o, hk_sym_o, hk_sym_O, hk_sym_oslash, hk_sym_Oslash,
	HKL_SYM1234 | hk_scan_p, hk_sym_p, hk_sym_P, hk_sym_thorn, hk_sym_THORN,
	HKL_SYM1234 | hk_scan_period, hk_sym_period, hk_sym_greater, hk_sym_periodcentered, hk_sym_division,
	HKL_SYM1234 | hk_scan_q, hk_sym_q, hk_sym_Q, hk_sym_at, hk_sym_Greek_OMEGA,
	HKL_SYM1234 | hk_scan_r, hk_sym_r, hk_sym_R, hk_sym_paragraph, hk_sym_registered,
	HKL_SYM1234 | hk_scan_s, hk_sym_s, hk_sym_S, hk_sym_ssharp, 0x1e9e,
	HKL_SYM1234 | hk_scan_semicolon, hk_sym_semicolon, hk_sym_colon, hk_sym_dead_acute, hk_sym_dead_doubleacute,
	HKL_SYM1234 | hk_scan_slash, hk_sym_slash, hk_sym_question, hk_sym_dead_belowdot, hk_sym_dead_abovedot,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_space, hk_sym_space,
	HKL_SYM1234 | hk_scan_t, hk_sym_t, hk_sym_T, hk_sym_tslash, hk_sym_Tslash,
	HKL_SYM1234 | hk_scan_u, hk_sym_u, hk_sym_U, hk_sym_downarrow, hk_sym_uparrow,
	HKL_SYM1234 | hk_scan_v, hk_sym_v, hk_sym_V, hk_sym_doublelowquotemark, hk_sym_singlelowquotemark,
	HKL_SYM1234 | hk_scan_w, hk_sym_w, hk_sym_W, 0x017f, hk_sym_section,
	HKL_SYM1234 | hk_scan_x, hk_sym_x, hk_sym_X, hk_sym_guillemetright, hk_sym_greater,
	HKL_SYM1234 | hk_scan_y, hk_sym_y, hk_sym_Y, hk_sym_leftarrow, hk_sym_yen,
	HKL_SYM1234 | hk_scan_z, hk_sym_z, hk_sym_Z, hk_sym_guillemetleft, hk_sym_less,
	HKL_END
};

// be, Belgian, AZERTY

static const uint16_t lang_be[] = {
	HKL_SYM12 | hk_scan_0, hk_sym_agrave, hk_sym_0,
	HKL_SYM12 | HKL_SYM3 | hk_scan_1, hk_sym_ampersand, hk_sym_1, hk_sym_bar,
	HKL_SYM12 | HKL_SYM3 | hk_scan_2, hk_sym_eacute, hk_sym_2, hk_sym_at,
	HKL_SYM12 | HKL_SYM3 | hk_scan_3, hk_sym_quotedbl, hk_sym_3, hk_sym_numbersign,
	HKL_SYM12 | hk_scan_4, hk_sym_apostrophe, hk_sym_4,
	HKL_SYM12 | hk_scan_5, hk_sym_parenleft, hk_sym_5,
	HKL_SYM12 | HKL_SYM3 | hk_scan_6, hk_sym_section, hk_sym_6, hk_sym_asciicircum,
	HKL_SYM12 | hk_scan_7, hk_sym_egrave, hk_sym_7,
	HKL_SYM12 | hk_scan_8, hk_sym_exclam, hk_sym_8,
	HKL_SYM12 | HKL_SYM3 | hk_scan_9, hk_sym_ccedilla, hk_sym_9, hk_sym_braceleft,
	HKL_SYM1234 | hk_scan_a, hk_sym_q, hk_sym_Q, hk_sym_at, hk_sym_Greek_OMEGA,
	HKL_SYM12 | HKL_SYM3 | hk_scan_apostrophe, hk_sym_ugrave, hk_sym_percent, hk_sym_dead_acute,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_less, hk_sym_greater, hk_sym_backslash, hk_sym_backslash,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketleft, hk_sym_dead_circumflex, hk_sym_dead_diaeresis, hk_sym_bracketleft,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketright, hk_sym_dollar, hk_sym_asterisk, hk_sym_bracketright,
	HKL_SYM12 | hk_scan_comma, hk_sym_semicolon, hk_sym_period,
	HKL_SYM34 | hk_scan_e, hk_sym_EuroSign, hk_sym_cent,
	HKL_SYM12 | hk_scan_equal, hk_sym_minus, hk_sym_underscore,
	HKL_SYM12 | hk_scan_grave, hk_sym_twosuperior, hk_sym_threesuperior,
	HKL_SYM12 | HKL_SYM3 | hk_scan_m, hk_sym_comma, hk_sym_question, hk_sym_dead_cedilla,
	HKL_SYM12 | hk_scan_minus, hk_sym_parenright, hk_sym_degree,
	HKL_SYM1234 | hk_scan_numbersign_nonUS, hk_sym_mu, hk_sym_sterling, hk_sym_dead_grave, hk_sym_dead_breve,
	HKL_SYM34 | hk_scan_o, hk_sym_oe, hk_sym_OE,
	HKL_SYM12 | hk_scan_period, hk_sym_colon, hk_sym_slash,
	HKL_SYM1234 | hk_scan_q, hk_sym_a, hk_sym_A, hk_sym_ae, hk_sym_AE,
	HKL_SYM12 | hk_scan_semicolon, hk_sym_m, hk_sym_M,
	HKL_SYM12 | HKL_SYM3 | hk_scan_slash, hk_sym_equal, hk_sym_plus, hk_sym_dead_tilde,
	HKL_SYM1234 | hk_scan_w, hk_sym_z, hk_sym_Z, hk_sym_guillemetleft, hk_sym_less,
	HKL_SYM12 | hk_scan_z, hk_sym_w, hk_sym_W,
	HKL_END
};

// br, Brazil, QWERTY

static const uint16_t lang_br[] = {
	HKL_SYM4 | hk_scan_2, hk_sym_onehalf,
	HKL_SYM4 | hk_scan_3, hk_sym_threequarters,
	HKL_SYM34 | hk_scan_4, hk_sym_sterling, hk_sym_onequarter,
	HKL_SYM3 | hk_scan_5, hk_sym_cent,
	HKL_SYM2 | HKL_SYM34 | hk_scan_6, hk_sym_dead_diaeresis, hk_sym_notsign, hk_sym_diaeresis,
	HKL_SYM1234 | hk_scan_International1, hk_sym_slash, hk_sym_question, hk_sym_degree, hk_sym_questiondown,
	HKL_SYM1234 | hk_scan_apostrophe, hk_sym_dead_tilde, hk_sym_dead_circumflex, hk_sym_asciitilde, hk_sym_asciicircum,
	HKL_SYM3 | hk_scan_backslash_nonUS, hk_sym_dead_caron,
	HKL_SYM1234 | hk_scan_bracketleft, hk_sym_dead_acute, hk_sym_dead_grave, hk_sym_acute, hk_sym_grave,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketright, hk_sym_bracketleft, hk_sym_braceleft, hk_sym_ordfeminine,
	HKL_SYM3 | hk_scan_c, hk_sym_copyright,
	HKL_SYM34 | hk_scan_e, hk_sym_degree, hk_sym_degree,
	HKL_SYM3 | hk_scan_equal, hk_sym_section,
	HKL_SYM12 | hk_scan_grave, hk_sym_apostrophe, hk_sym_quotedbl,
	HKL_SYM4 | hk_scan_m, hk_sym_mu,
	HKL_SYM1234 | hk_scan_numbersign_nonUS, hk_sym_bracketright, hk_sym_braceright, hk_sym_masculine, hk_sym_masculine,
	HKL_SYM34 | hk_scan_q, hk_sym_slash, hk_sym_slash,
	HKL_SYM3 | hk_scan_r, hk_sym_registered,
	HKL_SYM12 | hk_scan_semicolon, hk_sym_ccedilla, hk_sym_Ccedilla,
	HKL_SYM12 | hk_scan_slash, hk_sym_semicolon, hk_sym_colon,
	HKL_SYM34 | hk_scan_w, hk_sym_question, hk_sym_question,
	HKL_END
};

// de, German, QWERTZ

static const uint16_t lang_de[] = {
	HKL_SYM2 | hk_scan_0, hk_sym_equal,
	HKL_SYM2 | hk_scan_2, hk_sym_quotedbl,
	HKL_SYM2 | hk_scan_3, hk_sym_section,
	HKL_SYM4 | hk_scan_4, hk_sym_currency,
	HKL_SYM2 | HKL_SYM3 | hk_scan_6, hk_sym_ampersand, hk_sym_notsign,
	HKL_SYM2 | hk_scan_7, hk_sym_slash,
	HKL_SYM2 | hk_scan_8, hk_sym_parenleft,
	HKL_SYM2 | hk_scan_9, hk_sym_parenright,
	HKL_SYM12 | hk_scan_apostrophe, hk_sym_adiaeresis, hk_sym_Adiaeresis,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_less, hk_sym_greater, hk_sym_bar, hk_sym_dead_belowmacron,
	HKL_SYM12 | hk_scan_bracketleft, hk_sym_udiaeresis, hk_sym_Udiaeresis,
	HKL_SYM1234 | hk_scan_bracketright, hk_sym_plus, hk_sym_asterisk, hk_sym_asciitilde, hk_sym_macron,
	HKL_SYM2 | HKL_SYM3 | hk_scan_comma, hk_sym_semicolon, hk_sym_periodcentered,
	HKL_SYM34 | hk_scan_e, hk_sym_EuroSign, hk_sym_EuroSign,
	HKL_SYM12 | hk_scan_equal, hk_sym_dead_acute, hk_sym_dead_grave,
	HKL_SYM1234 | hk_scan_grave, hk_sym_dead_circumflex, hk_sym_degree, 0x2032, 0x2033,
	HKL_SYM34 | hk_scan_j, hk_sym_dead_belowdot, hk_sym_dead_abovedot,
	HKL_SYM12 | hk_scan_minus, hk_sym_ssharp, hk_sym_question,
	HKL_SYM1234 | hk_scan_numbersign_nonUS, hk_sym_numbersign, hk_sym_apostrophe, hk_sym_rightsinglequotemark, hk_sym_dead_breve,
	HKL_SYM2 | HKL_SYM3 | hk_scan_period, hk_sym_colon, 0x2026,
	HKL_SYM3 | hk_scan_s, 0x017f,
	HKL_SYM1234 | hk_scan_semicolon, hk_sym_odiaeresis, hk_sym_Odiaeresis, hk_sym_dead_doubleacute, hk_sym_dead_belowdot,
	HKL_SYM1234 | hk_scan_slash, hk_sym_minus, hk_sym_underscore, hk_sym_endash, hk_sym_emdash,
	HKL_SYM34 | hk_scan_x, hk_sym_guillemetleft, 0x2039,
	HKL_SYM12 | hk_scan_y, hk_sym_z, hk_sym_Z,
	HKL_SYM1234 | hk_scan_z, hk_sym_y, hk_sym_Y, hk_sym_guillemetright, 0x203a,
	HKL_END
};

// dk, Danish, QWERTY

static const uint16_t lang_dk[] = {
	HKL_SYM2 | hk_scan_0, hk_sym_equal,
	HKL_SYM34 | hk_scan_1, hk_sym_exclamdown, hk_sym_onesuperior,
	HKL_SYM2 | HKL_SYM34 | hk_scan_2, hk_sym_quotedbl, hk_sym_at, hk_sym_twosuperior,
	HKL_SYM34 | hk_scan_3, hk_sym_sterling, hk_sym_threesuperior,
	HKL_SYM2 | HKL_SYM34 | hk_scan_4, hk_sym_currency, hk_sym_dollar, hk_sym_onequarter,
	HKL_SYM4 | hk_scan_5, hk_sym_cent,
	HKL_SYM2 | HKL_SYM3 | hk_scan_6, hk_sym_ampersand, hk_sym_yen,
	HKL_SYM2 | HKL_SYM4 | hk_scan_7, hk_sym_slash, hk_sym_division,
	HKL_SYM2 | HKL_SYM4 | hk_scan_8, hk_sym_parenleft, hk_sym_guillemetleft,
	HKL_SYM2 | HKL_SYM4 | hk_scan_9, hk_sym_parenright, hk_sym_guillemetright,
	HKL_SYM34 | hk_scan_a, hk_sym_ordfeminine, hk_sym_masculine,
	HKL_SYM12 | hk_scan_apostrophe, hk_sym_oslash, hk_sym_Oslash,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_less, hk_sym_greater, hk_sym_backslash, hk_sym_notsign,
	HKL_SYM12 | hk_scan_bracketleft, hk_sym_aring, hk_sym_Aring,
	HKL_SYM12 | HKL_SYM4 | hk_scan_bracketright, hk_sym_dead_diaeresis, hk_sym_dead_circumflex, hk_sym_dead_caron,
	HKL_SYM3 | hk_scan_c, hk_sym_copyright,
	HKL_SYM2 | HKL_SYM34 | hk_scan_comma, hk_sym_semicolon, hk_sym_dead_cedilla, hk_sym_dead_ogonek,
	HKL_SYM34 | hk_scan_e, hk_sym_EuroSign, hk_sym_cent,
	HKL_SYM1234 | hk_scan_equal, hk_sym_dead_acute, hk_sym_dead_grave, hk_sym_bar, hk_sym_brokenbar,
	HKL_SYM1234 | hk_scan_grave, hk_sym_onehalf, hk_sym_section, hk_sym_threequarters, hk_sym_paragraph,
	HKL_SYM12 | HKL_SYM3 | hk_scan_minus, hk_sym_plus, hk_sym_question, hk_sym_plusminus,
	HKL_SYM1234 | hk_scan_numbersign_nonUS, hk_sym_apostrophe, hk_sym_asterisk, hk_sym_dead_doubleacute, hk_sym_multiply,
	HKL_SYM34 | hk_scan_o, hk_sym_oe, hk_sym_OE,
	HKL_SYM2 | HKL_SYM4 | hk_scan_period, hk_sym_colon, hk_sym_dead_abovedot,
	HKL_SYM3 | hk_scan_r, hk_sym_registered,
	HKL_SYM12 | hk_scan_semicolon, hk_sym_ae, hk_sym_AE,
	HKL_SYM12 | hk_scan_slash, hk_sym_minus, hk_sym_underscore,
	HKL_SYM34 | hk_scan_t, hk_sym_thorn, hk_sym_THORN,
	HKL_END
};

// es, Spanish, QWERTY

static const uint16_t lang_es[] = {
	HKL_SYM2 | hk_scan_0, hk_sym_equal,
	HKL_SYM3 | hk_scan_1, hk_sym_bar,
	HKL_SYM2 | HKL_SYM3 | hk_scan_2, hk_sym_quotedbl, hk_sym_at,
	HKL_SYM2 | HKL_SYM3 | hk_scan_3, hk_sym_periodcentered, hk_sym_numbersign,
	HKL_SYM3 | hk_scan_4, hk_sym_asciitilde,
	HKL_SYM2 | HKL_SYM3 | hk_scan_6, hk_sym_ampersand, hk_sym_notsign,
	HKL_SYM2 | hk_scan_7, hk_sym_slash,
	HKL_SYM2 | hk_scan_8, hk_sym_parenleft,
	HKL_SYM2 | hk_scan_9, hk_sym_parenright,
	HKL_SYM12 | HKL_SYM3 | hk_scan_apostrophe, hk_sym_dead_acute, hk_sym_dead_diaeresis, hk_sym_braceleft,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketleft, hk_sym_dead_grave, hk_sym_dead_circumflex, hk_sym_bracketleft,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketright, hk_sym_plus, hk_sym_asterisk, hk_sym_bracketright,
	HKL_SYM2 | hk_scan_comma, hk_sym_semicolon,
	HKL_SYM34 | hk_scan_e, hk_sym_EuroSign, hk_sym_cent,
	HKL_SYM12 | hk_scan_equal, hk_sym_exclamdown, hk_sym_questiondown,
	HKL_SYM1234 | hk_scan_grave, hk_sym_masculine, hk_sym_ordfeminine, hk_sym_backslash, hk_sym_backslash,
	HKL_SYM12 | hk_scan_minus, hk_sym_apostrophe, hk_sym_question,
	HKL_SYM1234 | hk_scan_numbersign_nonUS, hk_sym_ccedilla, hk_sym_Ccedilla, hk_sym_braceright, hk_sym_dead_breve,
	HKL_SYM2 | hk_scan_period, hk_sym_colon,
	HKL_SYM12 | HKL_SYM3 | hk_scan_semicolon, hk_sym_ntilde, hk_sym_Ntilde, hk_sym_dead_tilde,
	HKL_SYM12 | hk_scan_slash, hk_sym_minus, hk_sym_underscore,
	HKL_END
};

// fi, Finnish, QWERTY

static const uint16_t lang_fi[] = {
	HKL_LANG | HKL_SYM34 | hk_scan_1, hk_lang_dk, hk_sym_None, hk_sym_exclamdown,
	HKL_SYM4 | hk_scan_2, hk_sym_rightdoublequotemark,
	HKL_SYM4 | hk_scan_3, hk_sym_guillemetright,
	HKL_SYM4 | hk_scan_4, hk_sym_guillemetleft,
	HKL_SYM34 | hk_scan_5, hk_sym_permille, hk_sym_leftdoublequotemark,
	HKL_SYM34 | hk_scan_6, hk_sym_singlelowquotemark, hk_sym_doublelowquotemark,
	HKL_SYM4 | hk_scan_7, hk_sym_None,
	HKL_SYM4 | hk_scan_8, hk_sym_less,
	HKL_SYM4 | hk_scan_9, hk_sym_greater,
	HKL_SYM34 | hk_scan_a, hk_sym_schwa, hk_sym_SCHWA,
	HKL_SYM1234 | hk_scan_apostrophe, hk_sym_adiaeresis, hk_sym_Adiaeresis, hk_sym_ae, hk_sym_AE,
	HKL_DUP12 | HKL_SYM12 | hk_scan_b, hk_sym_b, hk_sym_B,
	HKL_SYM34 | hk_scan_backslash_nonUS, hk_sym_bar, hk_sym_None,
	HKL_SYM3 | hk_scan_bracketleft, hk_sym_dead_doubleacute,
	HKL_SYM4 | hk_scan_bracketright, hk_sym_dead_macron,
	HKL_DUP12 | HKL_SYM12 | hk_scan_c, hk_sym_c, hk_sym_C,
	HKL_SYM34 | hk_scan_comma, hk_sym_rightsinglequotemark, hk_sym_leftsinglequotemark,
	HKL_SYM4 | hk_scan_e, hk_sym_None,
	HKL_SYM34 | hk_scan_equal, hk_sym_dead_cedilla, hk_sym_dead_ogonek,
	HKL_DUP12 | HKL_SYM12 | hk_scan_f, hk_sym_f, hk_sym_F,
	HKL_DUP12 | HKL_SYM12 | hk_scan_g, hk_sym_g, hk_sym_G,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_grave, hk_sym_section, hk_sym_onehalf, hk_sym_dead_stroke,
	HKL_DUP12 | HKL_SYM12 | hk_scan_h, hk_sym_h, hk_sym_H,
	HKL_SYM34 | hk_scan_i, hk_sym_idotless, hk_sym_bar,
	HKL_DUP12 | HKL_SYM12 | hk_scan_j, hk_sym_j, hk_sym_J,
	HKL_SYM4 | hk_scan_k, hk_sym_dead_greek,
	HKL_SYM34 | hk_scan_l, hk_sym_dead_stroke, hk_sym_dead_currency,
	HKL_SYM4 | hk_scan_m, hk_sym_emdash,
	HKL_SYM3 | hk_scan_minus, hk_sym_backslash,
	HKL_SYM34 | hk_scan_n, hk_sym_eng, hk_sym_ENG,
	HKL_SYM34 | hk_scan_numbersign_nonUS, hk_sym_dead_caron, hk_sym_dead_breve,
	HKL_SYM34 | hk_scan_p, hk_sym_dead_horn, hk_sym_dead_hook,
	HKL_SYM3 | hk_scan_period, hk_sym_dead_belowdot,
	HKL_DUP12 | HKL_SYM12 | hk_scan_q, hk_sym_q, hk_sym_Q,
	HKL_DUP12 | HKL_SYM12 | hk_scan_r, hk_sym_r, hk_sym_R,
	HKL_SYM1234 | hk_scan_semicolon, hk_sym_odiaeresis, hk_sym_Odiaeresis, hk_sym_oslash, hk_sym_Oslash,
	HKL_SYM34 | hk_scan_slash, hk_sym_endash, hk_sym_dead_belowcomma,
	HKL_SYM4 | hk_scan_space, 0x202f,
	HKL_DUP12 | HKL_SYM12 | hk_scan_u, hk_sym_u, hk_sym_U,
	HKL_DUP12 | HKL_SYM12 | hk_scan_v, hk_sym_v, hk_sym_V,
	HKL_DUP12 | HKL_SYM12 | hk_scan_w, hk_sym_w, hk_sym_W,
	HKL_SYM34 | hk_scan_x, hk_sym_multiply, hk_sym_periodcentered,
	HKL_DUP12 | HKL_SYM12 | hk_scan_y, hk_sym_y, hk_sym_Y,
	HKL_SYM34 | hk_scan_z, hk_sym_ezh, hk_sym_EZH,
	HKL_END
};

// fr, French, AZERTY

static const uint16_t lang_fr[] = {
	HKL_LANG | HKL_SYM3 | hk_scan_0, hk_lang_be, hk_sym_at,
	HKL_SYM3 | hk_scan_1, hk_sym_onesuperior,
	HKL_SYM3 | hk_scan_2, hk_sym_asciitilde,
	HKL_SYM3 | hk_scan_4, hk_sym_braceleft,
	HKL_SYM3 | hk_scan_5, hk_sym_bracketleft,
	HKL_SYM1 | HKL_SYM3 | hk_scan_6, hk_sym_minus, hk_sym_bar,
	HKL_SYM3 | hk_scan_7, hk_sym_grave,
	HKL_SYM1 | HKL_SYM3 | hk_scan_8, hk_sym_underscore, hk_sym_backslash,
	HKL_SYM3 | hk_scan_9, hk_sym_asciicircum,
	HKL_SYM3 | hk_scan_apostrophe, hk_sym_dead_circumflex,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_backslash, hk_sym_bar, hk_sym_dead_grave, hk_sym_dead_breve,
	HKL_SYM3 | hk_scan_bracketleft, hk_sym_dead_diaeresis,
	HKL_SYM2 | HKL_SYM3 | hk_scan_bracketright, hk_sym_sterling, hk_sym_currency,
	HKL_SYM12 | HKL_SYM3 | hk_scan_equal, hk_sym_equal, hk_sym_plus, hk_sym_braceright,
	HKL_SYM2 | hk_scan_grave, hk_sym_asciitilde,
	HKL_SYM34 | hk_scan_m, hk_sym_dead_acute, hk_sym_dead_doubleacute,
	HKL_SYM3 | hk_scan_minus, hk_sym_bracketright,
	HKL_SYM12 | hk_scan_numbersign_nonUS, hk_sym_asterisk, hk_sym_mu,
	HKL_SYM34 | hk_scan_o, hk_sym_oslash, hk_sym_Oslash,
	HKL_SYM34 | hk_scan_semicolon, hk_sym_mu, hk_sym_masculine,
	HKL_SYM12 | HKL_SYM3 | hk_scan_slash, hk_sym_exclam, hk_sym_section, hk_sym_dead_belowdot,
	HKL_SYM34 | hk_scan_z, hk_sym_lstroke, hk_sym_Lstroke,
	HKL_END
};

// fr_CA, French Canadian, QWERTY

static const uint16_t lang_fr_CA[] = {
	HKL_LANG | HKL_SYM2 | HKL_SYM34 | hk_scan_0, hk_lang_fi, hk_sym_parenright, hk_sym_onequarter, hk_sym_None,
	HKL_SYM34 | hk_scan_1, hk_sym_plusminus, hk_sym_None,
	HKL_SYM4 | hk_scan_2, hk_sym_None,
	HKL_SYM2 | HKL_SYM4 | hk_scan_3, hk_sym_slash, hk_sym_None,
	HKL_SYM2 | HKL_SYM34 | hk_scan_4, hk_sym_dollar, hk_sym_cent, hk_sym_None,
	HKL_SYM34 | hk_scan_5, hk_sym_currency, hk_sym_None,
	HKL_SYM2 | HKL_SYM34 | hk_scan_6, hk_sym_question, hk_sym_notsign, hk_sym_None,
	HKL_SYM2 | HKL_SYM3 | hk_scan_7, hk_sym_ampersand, hk_sym_brokenbar,
	HKL_SYM2 | HKL_SYM34 | hk_scan_8, hk_sym_asterisk, hk_sym_twosuperior, hk_sym_None,
	HKL_SYM2 | HKL_SYM34 | hk_scan_9, hk_sym_parenleft, hk_sym_threesuperior, hk_sym_None,
	HKL_DUP12 | HKL_SYM12 | hk_scan_a, hk_sym_a, hk_sym_A,
	HKL_DUP1 | HKL_CLR | HKL_SYM1 | HKL_SYM3 | hk_scan_apostrophe, hk_sym_dead_grave, hk_sym_braceleft,
	HKL_SYM12 | HKL_SYM3 | hk_scan_backslash_nonUS, hk_sym_guillemetleft, hk_sym_guillemetright, hk_sym_degree,
	HKL_DUP1 | HKL_CLR | HKL_SYM1 | HKL_SYM3 | hk_scan_bracketleft, hk_sym_dead_circumflex, hk_sym_bracketleft,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_bracketright, hk_sym_dead_cedilla, hk_sym_dead_diaeresis, hk_sym_bracketright,
	HKL_SYM2 | HKL_SYM34 | hk_scan_comma, hk_sym_apostrophe, hk_sym_macron, hk_sym_None,
	HKL_DUP12 | HKL_SYM12 | hk_scan_d, hk_sym_d, hk_sym_D,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_equal, hk_sym_equal, hk_sym_plus, hk_sym_threequarters,
	HKL_SYM1234 | hk_scan_grave, hk_sym_numbersign, hk_sym_bar, hk_sym_backslash, hk_sym_notsign,
	HKL_DUP12 | HKL_SYM12 | hk_scan_i, hk_sym_i, hk_sym_I,
	HKL_DUP12 | HKL_SYM12 | hk_scan_k, hk_sym_k, hk_sym_K,
	HKL_DUP12 | HKL_SYM12 | hk_scan_l, hk_sym_l, hk_sym_L,
	HKL_SYM4 | hk_scan_m, hk_sym_None,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_minus, hk_sym_minus, hk_sym_underscore, hk_sym_onehalf,
	HKL_DUP12 | HKL_SYM12 | hk_scan_n, hk_sym_n, hk_sym_N,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_numbersign_nonUS, hk_sym_less, hk_sym_greater, hk_sym_braceright,
	HKL_SYM34 | hk_scan_o, hk_sym_section, hk_sym_None,
	HKL_SYM34 | hk_scan_p, hk_sym_paragraph, hk_sym_None,
	HKL_DUP1 | HKL_SYM1 | HKL_SYM34 | hk_scan_period, hk_sym_period, hk_sym_hyphen, hk_sym_None,
	HKL_DUP12 | HKL_SYM12 | hk_scan_s, hk_sym_s, hk_sym_S,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_semicolon, hk_sym_semicolon, hk_sym_colon, hk_sym_asciitilde,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_slash, hk_sym_eacute, hk_sym_Eacute, hk_sym_dead_acute,
	HKL_SYM34 | hk_scan_space, hk_sym_nobreakspace, hk_sym_None,
	HKL_DUP12 | HKL_SYM12 | hk_scan_t, hk_sym_t, hk_sym_T,
	HKL_DUP12 | HKL_SYM12 | hk_scan_x, hk_sym_x, hk_sym_X,
	HKL_SYM34 | hk_scan_y, hk_sym_yen, hk_sym_None,
	HKL_DUP12 | HKL_SYM12 | hk_scan_z, hk_sym_z, hk_sym_Z,
	HKL_END
};

// gb, Great Britain, QWERTY

static const uint16_t lang_gb[] = {
	HKL_SYM2 | hk_scan_2, hk_sym_quotedbl,
	HKL_DUP12 | HKL_SYM2 | hk_scan_3, hk_sym_sterling,
	HKL_SYM34 | hk_scan_4, hk_sym_EuroSign, hk_sym_onequarter,
	HKL_SYM2 | hk_scan_apostrophe, hk_sym_at,
	HKL_SYM34 | hk_scan_backslash_nonUS, hk_sym_bar, hk_sym_brokenbar,
	HKL_SYM2 | HKL_SYM34 | hk_scan_grave, hk_sym_notsign, hk_sym_bar, hk_sym_bar,
	HKL_SYM1 | HKL_SYM34 | hk_scan_numbersign_nonUS, hk_sym_numbersign, hk_sym_dead_grave, hk_sym_dead_breve,
	HKL_END
};

// is, Icelandic, QWERTY

static const uint16_t lang_is[] = {
	HKL_LANG | HKL_SYM3 | hk_scan_1, hk_lang_es, hk_sym_onesuperior,
	HKL_SYM3 | hk_scan_2, hk_sym_twosuperior,
	HKL_SYM2 | HKL_SYM3 | hk_scan_3, hk_sym_numbersign, hk_sym_threesuperior,
	HKL_SYM34 | hk_scan_4, hk_sym_onequarter, hk_sym_currency,
	HKL_DUP1 | HKL_SYM1 | HKL_SYM3 | hk_scan_apostrophe, hk_sym_dead_acute, hk_sym_dead_circumflex,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketleft, hk_sym_eth, hk_sym_ETH, hk_sym_dead_diaeresis,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketright, hk_sym_apostrophe, hk_sym_question, hk_sym_asciitilde,
	HKL_SYM34 | hk_scan_d, 0x201e, 0x201c,
	HKL_SYM12 | hk_scan_equal, hk_sym_minus, hk_sym_underscore,
	HKL_SYM1234 | hk_scan_grave, hk_sym_dead_abovering, hk_sym_dead_diaeresis, hk_sym_notsign, hk_sym_hyphen,
	HKL_SYM12 | hk_scan_minus, hk_sym_odiaeresis, hk_sym_Odiaeresis,
	HKL_SYM12 | HKL_SYM3 | hk_scan_numbersign_nonUS, hk_sym_plus, hk_sym_asterisk, hk_sym_grave,
	HKL_SYM34 | hk_scan_p, hk_sym_bar, hk_sym_Greek_pi,
	HKL_SYM12 | HKL_SYM3 | hk_scan_semicolon, hk_sym_ae, hk_sym_AE, hk_sym_asciicircum,
	HKL_SYM12 | hk_scan_slash, hk_sym_thorn, hk_sym_THORN,
	HKL_END
};

// it, Italian, QWERTY

static const uint16_t lang_it[] = {
	HKL_LANG | HKL_SYM4 | hk_scan_0, hk_lang_es, hk_sym_dead_ogonek,
	HKL_SYM3 | hk_scan_1, hk_sym_onesuperior,
	HKL_SYM34 | hk_scan_2, hk_sym_twosuperior, hk_sym_dead_doubleacute,
	HKL_SYM2 | HKL_SYM34 | hk_scan_3, hk_sym_sterling, hk_sym_threesuperior, hk_sym_dead_tilde,
	HKL_SYM34 | hk_scan_4, hk_sym_onequarter, hk_sym_oneeighth,
	HKL_SYM1234 | hk_scan_apostrophe, hk_sym_agrave, hk_sym_degree, hk_sym_numbersign, hk_sym_dead_abovering,
	HKL_SYM34 | hk_scan_b, hk_sym_rightdoublequotemark, hk_sym_rightsinglequotemark,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_less, hk_sym_greater, hk_sym_guillemetleft, hk_sym_guillemetright,
	HKL_SYM12 | HKL_SYM4 | hk_scan_bracketleft, hk_sym_egrave, hk_sym_eacute, hk_sym_braceleft,
	HKL_SYM4 | hk_scan_bracketright, hk_sym_braceright,
	HKL_SYM3 | hk_scan_comma, hk_sym_dead_acute,
	HKL_SYM1234 | hk_scan_equal, hk_sym_igrave, hk_sym_asciicircum, hk_sym_asciitilde, hk_sym_dead_circumflex,
	HKL_SYM1234 | hk_scan_grave, hk_sym_backslash, hk_sym_bar, hk_sym_notsign, hk_sym_brokenbar,
	HKL_SYM3 | hk_scan_minus, hk_sym_grave,
	HKL_SYM34 | hk_scan_n, hk_sym_ntilde, hk_sym_Ntilde,
	HKL_SYM12 | HKL_SYM3 | hk_scan_numbersign_nonUS, hk_sym_ugrave, hk_sym_section, hk_sym_dead_grave,
	HKL_SYM4 | hk_scan_period, hk_sym_dead_diaeresis,
	HKL_SYM1234 | hk_scan_semicolon, hk_sym_ograve, hk_sym_ccedilla, hk_sym_at, hk_sym_dead_cedilla,
	HKL_SYM34 | hk_scan_slash, hk_sym_dead_macron, hk_sym_division,
	HKL_SYM34 | hk_scan_v, hk_sym_leftdoublequotemark, hk_sym_leftsinglequotemark,
	HKL_END
};

// jp, Japanese, QWERTY (JIS)

static const uint16_t lang_jp[] = {
	HKL_LANG | HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_0, hk_lang_fr_CA, hk_sym_0,
	HKL_DUP12 | HKL_SYM12 | hk_scan_1, hk_sym_1, hk_sym_exclam,
	HKL_DUP12 | HKL_SYM12 | hk_scan_2, hk_sym_2, hk_sym_quotedbl,
	HKL_DUP12 | HKL_SYM12 | hk_scan_3, hk_sym_3, hk_sym_numbersign,
	HKL_DUP12 | HKL_SYM12 | hk_scan_4, hk_sym_4, hk_sym_dollar,
	HKL_DUP12 | HKL_SYM12 | hk_scan_5, hk_sym_5, hk_sym_percent,
	HKL_DUP12 | HKL_SYM12 | hk_scan_6, hk_sym_6, hk_sym_ampersand,
	HKL_DUP12 | HKL_SYM12 | hk_scan_7, hk_sym_7, hk_sym_apostrophe,
	HKL_DUP12 | HKL_SYM12 | hk_scan_8, hk_sym_8, hk_sym_parenleft,
	HKL_DUP12 | HKL_SYM12 | hk_scan_9, hk_sym_9, hk_sym_parenright,
	HKL_DUP12 | HKL_SYM1 | hk_scan_Caps_Lock, hk_sym_Eisu_toggle,
	HKL_DUP12 | HKL_SYM12 | hk_scan_International1, hk_sym_backslash, hk_sym_underscore,
	HKL_DUP12 | HKL_SYM12 | hk_scan_International2, hk_sym_Hiragana_Katakana, hk_sym_Romaji,
	HKL_DUP12 | HKL_SYM12 | hk_scan_International3, hk_sym_yen, hk_sym_bar,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_International4, hk_sym_Henkan,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_International5, hk_sym_Muhenkan,
	HKL_DUP12 | HKL_SYM12 | hk_scan_Lang5, hk_sym_Zenkaku_Hankaku, hk_sym_Kanji,
	HKL_DUP12 | HKL_SYM12 | hk_scan_apostrophe, hk_sym_colon, hk_sym_asterisk,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_backslash_nonUS, hk_sym_None,
	HKL_DUP12 | HKL_SYM12 | hk_scan_bracketleft, hk_sym_at, hk_sym_grave,
	HKL_DUP12 | HKL_SYM12 | hk_scan_bracketright, hk_sym_bracketleft, hk_sym_braceleft,
	HKL_DUP12 | HKL_SYM12 | hk_scan_comma, hk_sym_comma, hk_sym_less,
	HKL_DUP12 | HKL_SYM12 | hk_scan_e, hk_sym_e, hk_sym_E,
	HKL_DUP12 | HKL_SYM12 | hk_scan_equal, hk_sym_asciicircum, hk_sym_asciitilde,
	HKL_SYM12 | HKL_SYM3 | hk_scan_grave, hk_sym_grave, hk_sym_asciitilde, hk_sym_notsign,
	HKL_DUP12 | HKL_SYM12 | hk_scan_m, hk_sym_m, hk_sym_M,
	HKL_DUP12 | HKL_SYM12 | hk_scan_minus, hk_sym_minus, hk_sym_equal,
	HKL_DUP12 | HKL_SYM12 | hk_scan_numbersign_nonUS, hk_sym_bracketright, hk_sym_braceright,
	HKL_DUP12 | HKL_SYM12 | hk_scan_o, hk_sym_o, hk_sym_O,
	HKL_DUP12 | HKL_SYM12 | hk_scan_p, hk_sym_p, hk_sym_P,
	HKL_DUP12 | HKL_SYM12 | hk_scan_period, hk_sym_period, hk_sym_greater,
	HKL_DUP12 | HKL_SYM12 | hk_scan_semicolon, hk_sym_semicolon, hk_sym_plus,
	HKL_DUP12 | HKL_SYM12 | hk_scan_slash, hk_sym_slash, hk_sym_question,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_space, hk_sym_space,
	HKL_DUP12 | HKL_SYM12 | hk_scan_y, hk_sym_y, hk_sym_Y,
	HKL_END
};

// nl, Dutch, QWERTY

static const uint16_t lang_nl[] = {
	HKL_LANG | HKL_SYM2 | HKL_SYM34 | hk_scan_0, hk_lang_it, hk_sym_apostrophe, hk_sym_degree, hk_sym_trademark,
	HKL_SYM4 | hk_scan_2, hk_sym_oneeighth,
	HKL_SYM2 | HKL_SYM4 | hk_scan_3, hk_sym_numbersign, hk_sym_sterling,
	HKL_DUP12 | HKL_SYM2 | hk_scan_4, hk_sym_dollar,
	HKL_SYM3 | hk_scan_6, hk_sym_threequarters,
	HKL_SYM2 | HKL_SYM3 | hk_scan_7, hk_sym_underscore, hk_sym_sterling,
	HKL_SYM34 | hk_scan_8, hk_sym_braceleft, hk_sym_bracketleft,
	HKL_SYM34 | hk_scan_9, hk_sym_braceright, hk_sym_bracketright,
	HKL_SYM34 | hk_scan_a, hk_sym_aacute, hk_sym_Aacute,
	HKL_SYM1234 | hk_scan_apostrophe, hk_sym_dead_acute, hk_sym_dead_grave, hk_sym_apostrophe, hk_sym_grave,
	HKL_SYM1234 | hk_scan_backslash_nonUS, hk_sym_bracketright, hk_sym_bracketleft, hk_sym_bar, hk_sym_brokenbar,
	HKL_SYM1234 | hk_scan_bracketleft, hk_sym_dead_diaeresis, hk_sym_dead_circumflex, hk_sym_asciitilde, hk_sym_asciicircum,
	HKL_SYM1234 | hk_scan_bracketright, hk_sym_asterisk, hk_sym_bar, hk_sym_dead_tilde, hk_sym_dead_macron,
	HKL_SYM34 | hk_scan_comma, hk_sym_cedilla, hk_sym_guillemetleft,
	HKL_SYM1234 | hk_scan_equal, hk_sym_degree, hk_sym_dead_tilde, hk_sym_dead_cedilla, hk_sym_dead_ogonek,
	HKL_SYM3 | hk_scan_f, hk_sym_ordfeminine,
	HKL_SYM12 | HKL_SYM4 | hk_scan_grave, hk_sym_at, hk_sym_section, hk_sym_notsign,
	HKL_SYM34 | hk_scan_i, hk_sym_idiaeresis, hk_sym_Idiaeresis,
	HKL_SYM3 | hk_scan_m, hk_sym_Greek_mu,
	HKL_SYM1 | HKL_SYM3 | hk_scan_minus, hk_sym_slash, hk_sym_backslash,
	HKL_SYM12 | hk_scan_numbersign_nonUS, hk_sym_less, hk_sym_greater,
	HKL_SYM34 | hk_scan_o, hk_sym_ograve, hk_sym_Ograve,
	HKL_SYM3 | hk_scan_p, hk_sym_paragraph,
	HKL_SYM4 | hk_scan_period, hk_sym_guillemetright,
	HKL_SYM1234 | hk_scan_semicolon, hk_sym_plus, hk_sym_plusminus, hk_sym_dead_acute, hk_sym_dead_doubleacute,
	HKL_SYM2 | HKL_SYM34 | hk_scan_slash, hk_sym_equal, hk_sym_hyphen, hk_sym_dead_abovedot,
	HKL_SYM34 | hk_scan_t, hk_sym_thorn, hk_sym_THORN,
	HKL_SYM34 | hk_scan_u, hk_sym_udiaeresis, hk_sym_Udiaeresis,
	HKL_SYM3 | hk_scan_y, hk_sym_ydiaeresis,
	HKL_END
};

// no, Norwegian, QWERTY

static const uint16_t lang_no[] = {
	HKL_LANG | HKL_SYM4 | hk_scan_5, hk_lang_dk, hk_sym_permille,
	HKL_SYM12 | hk_scan_apostrophe, hk_sym_ae, hk_sym_AE,
	HKL_SYM34 | hk_scan_backslash_nonUS, hk_sym_onehalf, hk_sym_threequarters,
	HKL_SYM1234 | hk_scan_comma, hk_sym_period, hk_sym_colon, hk_sym_ellipsis, hk_sym_periodcentered,
	HKL_SYM1 | HKL_SYM34 | hk_scan_equal, hk_sym_backslash, hk_sym_dead_acute, hk_sym_notsign,
	HKL_SYM1 | HKL_SYM3 | hk_scan_grave, hk_sym_bar, hk_sym_brokenbar,
	HKL_SYM34 | hk_scan_p, hk_sym_Greek_pi, hk_sym_Greek_PI,
	HKL_SYM1234 | hk_scan_period, hk_sym_minus, hk_sym_underscore, hk_sym_endash, hk_sym_emdash,
	HKL_SYM4 | hk_scan_r, hk_sym_trademark,
	HKL_SYM12 | hk_scan_semicolon, hk_sym_oslash, hk_sym_Oslash,
	HKL_END
};

// pl, Polish, QWERTY

static const uint16_t lang_pl[] = {
	HKL_SYM3 | hk_scan_0, hk_sym_guillemetright,
	HKL_SYM3 | hk_scan_1, hk_sym_notequal,
	HKL_SYM4 | hk_scan_2, hk_sym_questiondown,
	HKL_SYM34 | hk_scan_4, hk_sym_cent, hk_sym_onequarter,
	HKL_SYM34 | hk_scan_5, hk_sym_EuroSign, hk_sym_permille,
	HKL_SYM34 | hk_scan_6, hk_sym_onehalf, hk_sym_logicaland,
	HKL_SYM34 | hk_scan_7, hk_sym_section, 0x2248,
	HKL_SYM34 | hk_scan_8, hk_sym_periodcentered, hk_sym_threequarters,
	HKL_SYM3 | hk_scan_9, hk_sym_guillemetleft,
	HKL_SYM34 | hk_scan_a, hk_sym_aogonek, hk_sym_Aogonek,
	HKL_SYM34 | hk_scan_b, hk_sym_rightdoublequotemark, hk_sym_leftdoublequotemark,
	HKL_SYM34 | hk_scan_c, hk_sym_cacute, hk_sym_Cacute,
	HKL_SYM3 | hk_scan_comma, hk_sym_lessthanequal,
	HKL_SYM34 | hk_scan_e, hk_sym_eogonek, hk_sym_Eogonek,
	HKL_SYM34 | hk_scan_f, hk_sym_ae, hk_sym_AE,
	HKL_SYM4 | hk_scan_grave, hk_sym_logicalor,
	HKL_SYM34 | hk_scan_h, hk_sym_rightsinglequotemark, 0x2022,
	HKL_SYM4 | hk_scan_i, 0x2194,
	HKL_SYM34 | hk_scan_j, hk_sym_schwa, hk_sym_SCHWA,
	HKL_SYM34 | hk_scan_k, hk_sym_ellipsis, hk_sym_dead_stroke,
	HKL_SYM4 | hk_scan_m, hk_sym_infinity,
	HKL_SYM34 | hk_scan_minus, hk_sym_endash, hk_sym_emdash,
	HKL_SYM34 | hk_scan_n, hk_sym_nacute, hk_sym_Nacute,
	HKL_SYM34 | hk_scan_o, hk_sym_oacute, hk_sym_Oacute,
	HKL_SYM3 | hk_scan_period, hk_sym_greaterthanequal,
	HKL_SYM3 | hk_scan_q, hk_sym_Greek_pi,
	HKL_SYM3 | hk_scan_r, hk_sym_copyright,
	HKL_SYM34 | hk_scan_s, hk_sym_sacute, hk_sym_Sacute,
	HKL_SYM34 | hk_scan_space, hk_sym_nobreakspace, hk_sym_nobreakspace,
	HKL_SYM34 | hk_scan_t, hk_sym_ssharp, hk_sym_trademark,
	HKL_SYM4 | hk_scan_v, hk_sym_leftsinglequotemark,
	HKL_SYM34 | hk_scan_w, hk_sym_oe, hk_sym_OE,
	HKL_SYM34 | hk_scan_x, hk_sym_zacute, hk_sym_Zacute,
	HKL_SYM34 | hk_scan_z, hk_sym_zabovedot, hk_sym_Zabovedot,
	HKL_END
};

// pl_QWERTZ, Polish, QWERTZ

static const uint16_t lang_pl_QWERTZ[] = {
	HKL_LANG | HKL_SYM3 | hk_scan_0, hk_lang_es, hk_sym_dead_doubleacute,
	HKL_SYM3 | hk_scan_1, hk_sym_asciitilde,
	HKL_SYM3 | hk_scan_2, hk_sym_dead_caron,
	HKL_SYM2 | HKL_SYM3 | hk_scan_3, hk_sym_numbersign, hk_sym_dead_circumflex,
	HKL_SYM3 | hk_scan_4, hk_sym_dead_breve,
	HKL_SYM3 | hk_scan_5, hk_sym_degree,
	HKL_SYM3 | hk_scan_6, hk_sym_dead_ogonek,
	HKL_SYM3 | hk_scan_7, hk_sym_dead_grave,
	HKL_SYM3 | hk_scan_8, hk_sym_dead_abovedot,
	HKL_SYM3 | hk_scan_9, hk_sym_dead_acute,
	HKL_SYM12 | HKL_SYM3 | hk_scan_apostrophe, hk_sym_aogonek, hk_sym_eogonek, hk_sym_ssharp,
	HKL_SYM34 | hk_scan_b, hk_sym_braceleft, hk_sym_apostrophe,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketleft, hk_sym_zabovedot, hk_sym_nacute, hk_sym_division,
	HKL_SYM12 | HKL_SYM3 | hk_scan_bracketright, hk_sym_sacute, hk_sym_cacute, hk_sym_multiply,
	HKL_SYM3 | hk_scan_comma, hk_sym_less,
	HKL_SYM3 | hk_scan_d, hk_sym_Dstroke,
	HKL_SYM12 | hk_scan_equal, hk_sym_apostrophe, hk_sym_asterisk,
	HKL_SYM3 | hk_scan_f, hk_sym_bracketleft,
	HKL_SYM3 | hk_scan_g, hk_sym_bracketright,
	HKL_SYM1234 | hk_scan_grave, hk_sym_abovedot, hk_sym_dead_ogonek, hk_sym_notsign, hk_sym_notsign,
	HKL_SYM3 | hk_scan_m, hk_sym_section,
	HKL_SYM1 | HKL_SYM3 | hk_scan_minus, hk_sym_plus, hk_sym_dead_diaeresis,
	HKL_SYM34 | hk_scan_n, hk_sym_braceright, hk_sym_acute,
	HKL_SYM12 | HKL_SYM3 | hk_scan_numbersign_nonUS, hk_sym_oacute, hk_sym_zacute, hk_sym_dead_grave,
	HKL_SYM3 | hk_scan_period, hk_sym_greater,
	HKL_SYM3 | hk_scan_q, hk_sym_backslash,
	HKL_SYM34 | hk_scan_s, hk_sym_dstroke, hk_sym_section,
	HKL_SYM12 | HKL_SYM3 | hk_scan_semicolon, hk_sym_lstroke, hk_sym_Lstroke, hk_sym_dollar,
	HKL_SYM34 | hk_scan_v, hk_sym_at, hk_sym_grave,
	HKL_SYM34 | hk_scan_w, hk_sym_bar, hk_sym_Greek_SIGMA,
	HKL_SYM12 | hk_scan_y, hk_sym_z, hk_sym_Z,
	HKL_SYM12 | hk_scan_z, hk_sym_y, hk_sym_Y,
	HKL_END
};

// se, Swedish, QWERTY

static const uint16_t lang_se[] = {
	HKL_LANG | HKL_SYM34 | hk_scan_5, hk_lang_dk, hk_sym_EuroSign, hk_sym_permille,
	HKL_SYM4 | hk_scan_6, hk_sym_radical,
	HKL_SYM1234 | hk_scan_apostrophe, hk_sym_adiaeresis, hk_sym_Adiaeresis, hk_sym_ae, hk_sym_AE,
	HKL_SYM34 | hk_scan_backslash_nonUS, hk_sym_bar, hk_sym_brokenbar,
	HKL_SYM34 | hk_scan_equal, hk_sym_plusminus, hk_sym_notsign,
	HKL_SYM1234 | hk_scan_grave, hk_sym_section, hk_sym_onehalf, hk_sym_paragraph, hk_sym_threequarters,
	HKL_SYM4 | hk_scan_k, hk_sym_dagger,
	HKL_SYM3 | hk_scan_minus, hk_sym_backslash,
	HKL_SYM3 | hk_scan_numbersign_nonUS, hk_sym_acute,
	HKL_SYM34 | hk_scan_p, hk_sym_Greek_pi, hk_sym_Greek_PI,
	HKL_SYM4 | hk_scan_period, hk_sym_ellipsis,
	HKL_SYM3 | hk_scan_q, hk_sym_Greek_omega,
	HKL_SYM4 | hk_scan_r, hk_sym_trademark,
	HKL_SYM1234 | hk_scan_semicolon, hk_sym_odiaeresis, hk_sym_Odiaeresis, hk_sym_oslash, hk_sym_Oslash,
	HKL_SYM4 | hk_scan_space, hk_sym_nobreakspace,
	HKL_SYM34 | hk_scan_w, hk_sym_Greek_sigma, hk_sym_Greek_SIGMA,
	HKL_END
};

// us, USA, QWERTY

static const uint16_t lang_us[] = {
	HKL_END
};

// DVORAK

static const uint16_t lang_dvorak[] = {
	HKL_LANG | HKL_DUP12 | HKL_SYM2 | hk_scan_0, hk_lang_jp, hk_sym_parenright,
	HKL_DUP12 | HKL_SYM2 | hk_scan_2, hk_sym_at,
	HKL_SYM2 | HKL_SYM34 | hk_scan_6, hk_sym_asciicircum, hk_sym_dead_circumflex, hk_sym_dead_circumflex,
	HKL_DUP12 | HKL_SYM2 | hk_scan_7, hk_sym_ampersand,
	HKL_DUP12 | HKL_SYM2 | hk_scan_8, hk_sym_asterisk,
	HKL_SYM2 | HKL_SYM34 | hk_scan_9, hk_sym_parenleft, hk_sym_dead_grave, hk_sym_dead_breve,
	HKL_DUP1 | HKL_DUP12 | HKL_SYM1 | hk_scan_Caps_Lock, hk_sym_Caps_Lock,
	HKL_DUP1 | HKL_DUP12 | HKL_CLR | hk_scan_International1,
	HKL_DUP1 | HKL_DUP12 | HKL_CLR | hk_scan_International2,
	HKL_DUP1 | HKL_DUP12 | HKL_CLR | hk_scan_International3,
	HKL_DUP1 | HKL_DUP12 | HKL_CLR | hk_scan_International4,
	HKL_DUP1 | HKL_DUP12 | HKL_CLR | hk_scan_International5,
	HKL_DUP1 | HKL_DUP12 | HKL_CLR | hk_scan_Lang5,
	HKL_DUP12 | HKL_SYM12 | hk_scan_apostrophe, hk_sym_minus, hk_sym_underscore,
	HKL_DUP12 | HKL_SYM12 | hk_scan_b, hk_sym_x, hk_sym_X,
	HKL_DUP12 | HKL_SYM12 | hk_scan_backslash_nonUS, hk_sym_backslash, hk_sym_bar,
	HKL_DUP12 | HKL_SYM12 | hk_scan_bracketleft, hk_sym_slash, hk_sym_question,
	HKL_DUP12 | HKL_SYM12 | hk_scan_bracketright, hk_sym_equal, hk_sym_plus,
	HKL_DUP12 | HKL_SYM12 | hk_scan_c, hk_sym_j, hk_sym_J,
	HKL_DUP12 | HKL_SYM12 | hk_scan_comma, hk_sym_w, hk_sym_W,
	HKL_DUP12 | HKL_SYM12 | hk_scan_d, hk_sym_e, hk_sym_E,
	HKL_SYM1234 | hk_scan_e, hk_sym_period, hk_sym_greater, hk_sym_dead_abovedot, hk_sym_periodcentered,
	HKL_CLR | HKL_SYM12 | HKL_SYM3 | hk_scan_equal, hk_sym_bracketright, hk_sym_braceright, hk_sym_dead_tilde,
	HKL_DUP12 | HKL_SYM12 | hk_scan_f, hk_sym_u, hk_sym_U,
	HKL_DUP12 | HKL_SYM12 | hk_scan_g, hk_sym_i, hk_sym_I,
	HKL_SYM34 | hk_scan_grave, hk_sym_dead_grave, hk_sym_dead_tilde,
	HKL_DUP12 | HKL_SYM12 | hk_scan_h, hk_sym_d, hk_sym_D,
	HKL_DUP12 | HKL_SYM12 | hk_scan_i, hk_sym_c, hk_sym_C,
	HKL_DUP12 | HKL_SYM12 | hk_scan_j, hk_sym_h, hk_sym_H,
	HKL_DUP12 | HKL_SYM12 | hk_scan_k, hk_sym_t, hk_sym_T,
	HKL_DUP12 | HKL_SYM12 | hk_scan_l, hk_sym_n, hk_sym_N,
	HKL_DUP12 | HKL_SYM12 | hk_scan_minus, hk_sym_bracketleft, hk_sym_braceleft,
	HKL_DUP12 | HKL_SYM12 | hk_scan_n, hk_sym_b, hk_sym_B,
	HKL_DUP12 | HKL_SYM12 | hk_scan_numbersign_nonUS, hk_sym_backslash, hk_sym_bar,
	HKL_DUP12 | HKL_SYM12 | hk_scan_o, hk_sym_r, hk_sym_R,
	HKL_DUP12 | HKL_SYM12 | hk_scan_p, hk_sym_l, hk_sym_L,
	HKL_DUP12 | HKL_SYM12 | hk_scan_period, hk_sym_v, hk_sym_V,
	HKL_SYM1234 | hk_scan_q, hk_sym_apostrophe, hk_sym_quotedbl, hk_sym_dead_acute, hk_sym_dead_diaeresis,
	HKL_DUP12 | HKL_SYM12 | hk_scan_r, hk_sym_p, hk_sym_P,
	HKL_DUP12 | HKL_SYM12 | hk_scan_s, hk_sym_o, hk_sym_O,
	HKL_DUP12 | HKL_SYM12 | hk_scan_semicolon, hk_sym_s, hk_sym_S,
	HKL_DUP12 | HKL_SYM12 | hk_scan_slash, hk_sym_z, hk_sym_Z,
	HKL_DUP12 | HKL_SYM12 | hk_scan_t, hk_sym_y, hk_sym_Y,
	HKL_DUP12 | HKL_SYM12 | hk_scan_u, hk_sym_g, hk_sym_G,
	HKL_DUP12 | HKL_SYM12 | hk_scan_v, hk_sym_k, hk_sym_K,
	HKL_SYM1234 | hk_scan_w, hk_sym_comma, hk_sym_less, hk_sym_dead_cedilla, hk_sym_dead_caron,
	HKL_DUP12 | HKL_SYM12 | hk_scan_x, hk_sym_q, hk_sym_Q,
	HKL_DUP12 | HKL_SYM12 | hk_scan_y, hk_sym_f, hk_sym_F,
	HKL_SYM1234 | hk_scan_z, hk_sym_semicolon, hk_sym_colon, hk_sym_dead_ogonek, hk_sym_dead_doubleacute,
	HKL_END
};

// Language tables, indexed by hk_lang_*

static const uint16_t *lang_table[] = {
	lang_default, lang_be, lang_br, lang_de, lang_dk, lang_es, lang_fi, lang_fr, lang_fr_CA, lang_gb, lang_is, lang_it, lang_jp, lang_nl, lang_no, lang_pl, lang_pl_QWERTZ, lang_se, lang_us, lang_dvorak
};
